/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.mail;

import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.configuration.Config;
import net.impactdev.impactor.api.mail.MailMessage;
import net.impactdev.impactor.api.mail.MailService;
import net.impactdev.impactor.api.mail.events.SendMailEvent;
import net.impactdev.impactor.api.mail.filters.MailFilter;
import net.impactdev.impactor.api.storage.StorageType;
import net.impactdev.impactor.core.mail.ImpactorMailMessage;
import net.impactdev.impactor.core.mail.MailConfig;
import net.impactdev.impactor.core.mail.storage.MailStorage;
import net.impactdev.impactor.core.mail.storage.MailStorageFactory;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.TriState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImpactorMailService
implements MailService {
    private final Config config = (Config)Config.builder().path(BaseImpactorPlugin.instance().configurationDirectory().resolve("mail.conf")).provider(MailConfig.class).provideIfMissing(() -> BaseImpactorPlugin.instance().resource(root -> root.resolve("configs").resolve("mail.conf"))).build();
    private final MailStorage storage = MailStorageFactory.instance(BaseImpactorPlugin.instance(), this.config.get(MailConfig.STORAGE_TYPE), StorageType.JSON);

    @Override
    public CompletableFuture<List<MailMessage>> inbox(@NotNull UUID target) {
        return this.storage.mail(target).orTimeout(5L, TimeUnit.SECONDS);
    }

    @Override
    public CompletableFuture<Boolean> sendFromServer(@NotNull UUID target, @NotNull Component message) {
        return this.send(target, new ImpactorMailMessage(UUID.randomUUID(), null, message, Instant.now()));
    }

    @Override
    public CompletableFuture<Boolean> send(@NotNull UUID source2, @NotNull UUID target, @NotNull Component message) {
        return this.send(target, new ImpactorMailMessage(UUID.randomUUID(), source2, message, Instant.now()));
    }

    @Override
    public CompletableFuture<Boolean> send(@NotNull UUID target, @NotNull MailMessage message) {
        SendMailEvent event = new SendMailEvent(target, message);
        Impactor.instance().events().post((Object)event);
        return this.storage.send(target, message);
    }

    @Override
    public CompletableFuture<TriState> delete(@NotNull UUID target, @NotNull MailMessage message) {
        return this.storage.delete(target, message);
    }

    @Override
    public CompletableFuture<TriState> deleteWhere(@NotNull UUID target, @Nullable MailFilter filter) {
        return this.storage.deleteWhere(target, filter);
    }

    @Override
    public String name() {
        return "Impactor Mail Service";
    }
}

